# 🤖 Telegram Group Assistant Bot

A PHP-based Telegram bot that acts as your group chat assistant with smart notifications and group management features.

## Features

### 👯 Chick Management
- Add special users ("chicks") to your list
- Get notified when they send messages in groups
- Receive notifications when someone replies to their messages

### 📊 Group Management
- Create custom groups/lists
- Add users to groups with `/add <group_name>` command (reply to user)
- Remove users with `/remove <group_name> <user_id>`
- Mention entire groups by typing the group name in chat

### 🔔 Notifications
- Get private messages when chicks send messages in groups
- Get private messages when someone replies to a chick's message
- Never spam the group chat

## Installation

### Prerequisites
- PHP 7.4 or higher
- cURL extension enabled
- A Telegram bot token (create one with [@BotFather](https://t.me/botfather))
- Your Telegram User ID

### Step 1: Get Your Bot Token
1. Open Telegram and search for [@BotFather](https://t.me/botfather)
2. Send `/newbot` and follow the instructions
3. Copy your bot token (looks like `123456:ABC-DEF1234ghIkl-zyx57W2v1u123ew11`)

### Step 2: Get Your User ID
1. Send a message to [@userinfobot](https://t.me/userinfobot)
2. It will reply with your user ID (a number like `123456789`)

### Step 3: Configure the Bot
Edit [config/config.php](config/config.php):

```php
define('TELEGRAM_TOKEN', 'YOUR_BOT_TOKEN_HERE'); // Paste your token
define('OWNER_ID', 123456789); // Paste your user ID
```

### Step 4: Deploy

#### Option A: Using a Hosting Service (Production)

1. Upload all files to your hosting (e.g., Heroku, AWS, DigitalOcean, etc.)
2. Make sure the `data/` directory is writable
3. Set the webhook:

```bash
curl -X POST "https://api.telegram.org/botYOUR_TOKEN/setWebhook?url=https://yourdomain.com/webhook.php"
```

Replace `yourdomain.com` with your actual domain and `YOUR_TOKEN` with your bot token.

#### Option B: Local Testing

Run the included development server:

```bash
php -S localhost:8000 server.php
```

Then visit `http://localhost:8000` to test actions.

## Commands

### Chick Management
- `/addchick` - Reply to a message to add user as "chick"
- `/removechick` - Remove a chick from your list
- `/listchicks` - Show all your chicks
- `/help` - Show all available commands

### Group Management
- `/add <group_name>` - Reply to a user to add them to a group
  ```
  Reply to Alice's message and send: /add developers
  ```
- `/remove <group_name> <user_id>` - Remove user from group
- `/groups` - List all your groups
- `/groupmembers <group_name>` - List members in a group

### Group Mention
Just type the group name in a group chat to mention everyone:

```
Someone sends: developers
Bot replies: 👥 developers: Alice Bob Charlie
```

## File Structure

```
telegram-bot/
├── config/
│   └── config.php           # Configuration file
├── src/
│   ├── Storage.php          # User and group storage
│   ├── TelegramBot.php      # Bot API wrapper
│   ├── CommandHandler.php   # Command processing
│   └── NotificationHandler.php # Notifications
├── data/
│   ├── users.json           # Chicks list
│   └── groups.json          # Groups and members
├── webhook.php              # Main webhook handler
├── server.php               # Development server
└── README.md                # This file
```

## How It Works

### Chick Notifications
1. You add Alice as a "chick"
2. When Alice sends a message in your group, the bot notifies you privately
3. When someone replies to Alice's message, the bot notifies you privately

### Group Mentions
1. You create a group called "developers"
2. You add Alice, Bob, and Charlie to the group
3. Anyone in the group sends "developers"
4. Bot automatically mentions all 3: `@Alice @Bob @Charlie`

## Database Structure

### users.json
```json
{
  "chicks": [123, 456, 789],
  "settings": {}
}
```

### groups.json
```json
{
  "developers": {
    "123": "Alice",
    "456": "Bob"
  },
  "designers": {
    "789": "Charlie"
  }
}
```

## Troubleshooting

### Bot not responding?
1. Check that your bot token is correct in `config.php`
2. Verify webhook is set correctly:
   ```bash
   curl "https://api.telegram.org/botYOUR_TOKEN/getWebhookInfo"
   ```
3. Check PHP error logs on your hosting

### Notifications not working?
1. Make sure `OWNER_ID` is set to your actual user ID
2. Verify the `data/` directory exists and is writable
3. Use the development server to test: `php -S localhost:8000 server.php`

### Can't add users to groups?
- Make sure you reply to a message from the user before using `/add`
- Use `/listchicks` to verify user IDs are correct

## Future Enhancements

- Database support (MySQL, PostgreSQL)
- Admin controls for multiple users
- Custom notification messages
- Schedule messages
- Message filtering/keywords
- Inline keyboards for easier interaction

## License

MIT License - Feel free to modify and use!

## Support

For issues or questions, refer to:
- [Telegram Bot API Docs](https://core.telegram.org/bots/api)
- [Telegram Bot FAQ](https://core.telegram.org/bots/faq)

---

**Made with ❤️ for Telegram group management**
