<?php
/**
 * Local Development Server
 * Run this file to test the bot locally
 * php -S localhost:8000 server.php
 */

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/src/Storage.php';
require_once __DIR__ . '/src/TelegramBot.php';
require_once __DIR__ . '/src/CommandHandler.php';
require_once __DIR__ . '/src/NotificationHandler.php';

// Simple router for testing
$request = $_GET['action'] ?? '';

switch ($request) {
    case 'test_chick_message':
        // Simulate a chick sending a message in a group
        $testUpdate = [
            'message' => [
                'message_id' => 1,
                'from' => ['id' => 123, 'first_name' => 'Alice'],
                'chat' => ['id' => -456, 'type' => 'group'],
                'text' => 'Hello everyone!'
            ]
        ];
        
        // Add a test chick first
        Storage::addChick(123);
        
        echo "✅ Added test chick (ID: 123)<br>";
        echo "Test update data logged<br>";
        echo "<pre>" . json_encode($testUpdate, JSON_PRETTY_PRINT) . "</pre>";
        break;
        
    case 'test_add_group':
        // Test adding to group
        Storage::createGroup('developers');
        Storage::addToGroup('developers', 123, 'Alice');
        Storage::addToGroup('developers', 456, 'Bob');
        
        echo "✅ Created group 'developers' with members<br>";
        echo "<pre>";
        print_r(Storage::getGroupMembers('developers'));
        echo "</pre>";
        break;
        
    case 'list_chicks':
        $chicks = Storage::getChicks();
        echo "<h3>Your Chicks:</h3>";
        echo "<pre>" . json_encode($chicks, JSON_PRETTY_PRINT) . "</pre>";
        break;
        
    case 'list_groups':
        $groups = Storage::getGroups();
        echo "<h3>Your Groups:</h3>";
        echo "<pre>" . json_encode($groups, JSON_PRETTY_PRINT) . "</pre>";
        break;
        
    case 'reset':
        file_put_contents(STORAGE_FILE, json_encode(['chicks' => [], 'settings' => []], JSON_PRETTY_PRINT));
        file_put_contents(GROUPS_FILE, json_encode([], JSON_PRETTY_PRINT));
        echo "✅ All data reset!";
        break;
        
    default:
        echo "<h1>🤖 Telegram Bot - Development Server</h1>";
        echo "<h2>Test Actions:</h2>";
        echo "<ul>";
        echo "<li><a href='?action=test_chick_message'>Test Chick Message</a></li>";
        echo "<li><a href='?action=test_add_group'>Test Add Group</a></li>";
        echo "<li><a href='?action=list_chicks'>List Chicks</a></li>";
        echo "<li><a href='?action=list_groups'>List Groups</a></li>";
        echo "<li><a href='?action=reset'>Reset All Data</a></li>";
        echo "</ul>";
        echo "<h2>Configuration:</h2>";
        echo "<code>TELEGRAM_TOKEN: " . substr(TELEGRAM_TOKEN, 0, 10) . "...</code><br>";
        echo "<code>OWNER_ID: " . OWNER_ID . "</code>";
}
