<?php

class NotificationHandler {
    
    private $bot;
    
    public function __construct(TelegramBot $bot) {
        $this->bot = $bot;
    }
    
    /**
     * Process notifications for chicks and group members
     */
    public function process() {
        $userId = $this->bot->getUserId();
        $userName = $this->bot->getUserFirstName();
        $chatId = $this->bot->getChatId();
        $chatType = $this->bot->getChatType();
        $text = $this->bot->getText();
        
        // Only process in groups
        if ($chatType !== 'group' && $chatType !== 'supergroup') {
            return false;
        }
        
        $chicks = Storage::getChicks();
        
        // Notify if a chick sends a message
        if (in_array($userId, $chicks)) {
            $this->notifyChickMessage($userId, $userName, $text, $chatId);
        }
        
        // Notify if someone replies to a chick's message
        if ($this->bot->isReply()) {
            $repliedMsg = $this->bot->getRepliedMessage();
            $repliedUserId = $repliedMsg['from']['id'];
            
            if (in_array($repliedUserId, $chicks)) {
                $this->notifyReplyToChick($userId, $userName, $repliedUserId, $repliedMsg['from']['first_name'], $text);
            }
        }
        
        return true;
    }
    
    /**
     * Send notification when a chick sends a message
     */
    private function notifyChickMessage($chicksId, $chicksName, $message, $groupChatId) {
        $text = "👯 <b>Message from your chick!</b>\n\n";
        $text .= "<b>Name:</b> $chicksName\n";
        $text .= "<b>Group ID:</b> <code>$groupChatId</code>\n";
        $text .= "<b>Message:</b> <code>$message</code>\n";
        
        $this->bot->sendMessage(OWNER_ID, $text);
    }
    
    /**
     * Send notification when someone replies to a chick
     */
    private function notifyReplyToChick($replyerId, $replierName, $chicksId, $chicksName, $replyText) {
        $text = "💬 <b>Someone replied to your chick!</b>\n\n";
        $text .= "<b>Chick:</b> $chicksName\n";
        $text .= "<b>Replied by:</b> $replierName\n";
        $text .= "<b>Reply:</b> <code>$replyText</code>\n";
        
        $this->bot->sendMessage(OWNER_ID, $text);
    }
}
