<?php

class Storage {
    
    /**
     * Get all chicks (special users)
     */
    public static function getChicks() {
        $data = json_decode(file_get_contents(STORAGE_FILE), true);
        return $data['chicks'] ?? [];
    }
    
    /**
     * Add a chick
     */
    public static function addChick($userId) {
        $data = json_decode(file_get_contents(STORAGE_FILE), true);
        if (!in_array($userId, $data['chicks'])) {
            $data['chicks'][] = $userId;
            file_put_contents(STORAGE_FILE, json_encode($data, JSON_PRETTY_PRINT));
            return true;
        }
        return false;
    }
    
    /**
     * Remove a chick
     */
    public static function removeChick($userId) {
        $data = json_decode(file_get_contents(STORAGE_FILE), true);
        $key = array_search($userId, $data['chicks']);
        if ($key !== false) {
            unset($data['chicks'][$key]);
            $data['chicks'] = array_values($data['chicks']); // Re-index array
            file_put_contents(STORAGE_FILE, json_encode($data, JSON_PRETTY_PRINT));
            return true;
        }
        return false;
    }
    
    /**
     * Get all groups
     */
    public static function getGroups() {
        return json_decode(file_get_contents(GROUPS_FILE), true) ?? [];
    }
    
    /**
     * Create a new group
     */
    public static function createGroup($groupName) {
        $groups = self::getGroups();
        if (!isset($groups[$groupName])) {
            $groups[$groupName] = [];
            file_put_contents(GROUPS_FILE, json_encode($groups, JSON_PRETTY_PRINT));
            return true;
        }
        return false;
    }
    
    /**
     * Add user to group
     */
    public static function addToGroup($groupName, $userId, $userFirstName = '') {
        $groups = self::getGroups();
        if (!isset($groups[$groupName])) {
            $groups[$groupName] = [];
        }
        
        if (!isset($groups[$groupName][$userId])) {
            $groups[$groupName][$userId] = $userFirstName;
            file_put_contents(GROUPS_FILE, json_encode($groups, JSON_PRETTY_PRINT));
            return true;
        }
        return false;
    }
    
    /**
     * Remove user from group
     */
    public static function removeFromGroup($groupName, $userId) {
        $groups = self::getGroups();
        if (isset($groups[$groupName][$userId])) {
            unset($groups[$groupName][$userId]);
            file_put_contents(GROUPS_FILE, json_encode($groups, JSON_PRETTY_PRINT));
            return true;
        }
        return false;
    }
    
    /**
     * Get members of a group
     */
    public static function getGroupMembers($groupName) {
        $groups = self::getGroups();
        return $groups[$groupName] ?? [];
    }
    
    /**
     * Check if group exists
     */
    public static function groupExists($groupName) {
        $groups = self::getGroups();
        return isset($groups[$groupName]);
    }
}
